function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = World_Economy_Cartel_corr_reserves.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(66, 122);
g1(1,22)=T(29)+T(32);
g1(1,25)=T(29);
g1(1,11)=T(31);
g1(1,39)=exp(y(22))*exp(y(25))*T(74);
g1(1,40)=T(106);
g1(1,43)=T(107);
g1(1,56)=exp(y(22));
g1(1,18)=T(226);
g1(1,20)=T(30)*(-(exp(y(22))*exp(y(43))));
g1(1,77)=(-1);
g1(1,112)=params(21);
g1(2,23)=T(24)*(-exp(y(23)))+exp(y(23))*y(60)+y(70)*(-(T(28)*params(4)*params(4)*exp(y(23)*params(4))));
g1(2,39)=(-exp(y(23)))*T(74);
g1(2,40)=(-exp(y(23)))*T(87);
g1(2,60)=exp(y(23));
g1(2,70)=(-(T(28)*params(4)*exp(y(23)*params(4))));
g1(2,79)=(-1);
g1(2,114)=params(21);
g1(3,24)=y(69)*(-(T(27)*params(4)*params(4)*exp(y(24)*params(4))))+exp(y(24))*y(60)+y(65)*y(35)*T(27)*params(4)*(params(4)-1)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(3,35)=y(65)*T(27)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(3,60)=exp(y(24));
g1(3,65)=y(35)*T(27)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(3,69)=(-(T(27)*params(4)*exp(y(24)*params(4))));
g1(3,78)=(-1);
g1(3,113)=params(21);
g1(4,22)=T(29);
g1(4,25)=T(24)*T(33)+y(73)*(-exp(y(25)))+exp(y(25))*y(72);
g1(4,39)=T(33)*T(74);
g1(4,40)=T(33)*T(87);
g1(4,45)=T(99);
g1(4,52)=T(24)*T(104);
g1(4,72)=exp(y(25));
g1(4,73)=(-exp(y(25)));
g1(4,81)=(-1);
g1(4,116)=params(21);
g1(5,26)=y(73)*(-exp(y(26)))+exp(y(26))*y(71);
g1(5,71)=exp(y(26));
g1(5,73)=(-exp(y(26)));
g1(5,80)=(-1);
g1(5,115)=params(21);
g1(6,27)=T(35);
g1(6,31)=T(41);
g1(6,97)=T(221);
g1(6,102)=params(21)*exp(y(27))*params(6)*exp(params(5)*(y(31)-y(97)));
g1(6,68)=exp(y(27));
g1(6,105)=params(21)*(-(exp(y(27))*(1-exp((-y(97)))*exp(y(31)))));
g1(6,109)=T(228);
g1(6,84)=(-1);
g1(6,119)=params(21);
g1(7,28)=T(37);
g1(7,32)=T(110);
g1(7,102)=params(21)*params(6)*exp(params(5)*y(32))*exp(y(28));
g1(7,67)=exp(y(28));
g1(7,104)=params(21)*(-((1-exp(y(32)))*exp(y(28))));
g1(7,108)=params(21)*(-(exp(y(32))*exp(y(28))));
g1(7,83)=(-1);
g1(7,118)=params(21);
g1(8,29)=T(38);
g1(8,68)=(-(params(7)*exp(y(29))));
g1(8,70)=exp(y(29));
g1(8,107)=params(21)*(-((1-params(7))*exp(y(29))));
g1(9,30)=T(39);
g1(9,67)=(-(params(7)*exp(y(30))));
g1(9,69)=exp(y(30));
g1(9,106)=params(21)*(-((1-params(7))*exp(y(30))));
g1(10,27)=T(41);
g1(10,31)=params(21)*y(111)*(-exp(y(31)))+T(113);
g1(10,97)=T(222);
g1(10,102)=params(21)*exp(y(27))*params(6)*params(5)*exp(params(5)*(y(31)-y(97)));
g1(10,105)=T(227);
g1(10,109)=T(228);
g1(10,111)=params(21)*(-exp(y(31)));
g1(11,87)=y(63)*T(108);
g1(11,28)=T(110);
g1(11,32)=T(36)+T(44)+y(66)*exp(y(95))*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(32)*(params(5)-1))+T(116)+params(21)*y(102)*exp(y(28))*params(6)*params(5)*params(5)*exp(params(5)*y(32));
g1(11,88)=y(63)*(-(exp(y(95))*(-exp(y(32)))));
g1(11,95)=y(66)*T(42)+y(63)*T(43);
g1(11,102)=params(21)*exp(y(28))*params(6)*params(5)*exp(params(5)*y(32));
g1(11,63)=T(43);
g1(11,66)=T(42);
g1(11,104)=params(21)*(-(exp(y(28))*(-exp(y(32)))));
g1(11,108)=params(21)*(-(exp(y(32))*exp(y(28))));
g1(12,33)=exp(y(33))*y(59);
g1(12,59)=exp(y(33));
g1(13,11)=T(30)*y(18)*(-(exp(y(43))*(-exp(y(11)))));
g1(13,43)=T(117);
g1(13,18)=T(30)*(-(exp(y(43))*(1-exp(y(11)))));
g1(13,63)=1;
g1(13,64)=(-params(7));
g1(13,20)=exp(y(43))*T(30);
g1(14,24)=y(65)*T(27)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(14,43)=T(30)*y(19)*(-(exp(y(43))*(1-params(7))));
g1(14,19)=T(30)*(-(exp(y(43))*(1-params(7))));
g1(14,64)=1;
g1(14,65)=params(4)*exp(y(24)*(params(4)-1))*T(27);
g1(15,36)=T(8)*y(73)+y(56)*(-(params(11)*T(12)*T(120)))+y(55)*(-(T(47)*T(124)+params(11)*T(46)*params(11)*T(46)*T(125)));
g1(15,37)=y(56)*(-(T(45)*params(11)*T(48)));
g1(15,13)=y(55)*(-(params(11)*T(46)*T(125)*T(140)));
g1(15,39)=y(55)*(-(params(11)*T(46)*T(84)*T(125)));
g1(15,44)=y(55)*(-(params(11)*T(46)*T(95)*T(125)));
g1(15,55)=(-(params(11)*T(46)*T(47)));
g1(15,56)=(-(params(11)*T(12)*T(45)));
g1(15,73)=T(8);
g1(16,36)=y(56)*(-(T(45)*params(11)*T(48)));
g1(16,37)=y(60)*(-exp(y(37)))+y(58)*(-(T(5)*T(19)*T(16)*exp(T(1)*y(44))*(1-params(11))*params(3)*T(130)))+y(57)*(-(T(17)*T(3)*T(16)*exp(T(1)*y(44))*(1-params(11))*(1-params(3))*T(130)))+exp(y(37))*y(55)+y(56)*(-(T(14)*params(11)*T(130)));
g1(16,13)=y(58)*T(142)+y(57)*(-(T(17)*T(143)));
g1(16,39)=T(131);
g1(16,44)=T(134);
g1(16,55)=exp(y(37));
g1(16,56)=(-(T(14)*params(11)*T(48)));
g1(16,57)=(-(T(17)*T(3)*T(16)*T(50)));
g1(16,58)=(-(T(5)*T(19)*T(16)*T(49)));
g1(16,60)=(-exp(y(37)));
g1(16,82)=(-1);
g1(16,117)=params(21);
g1(17,90)=params(21)*y(98)*(-(T(57)*params(11)*T(126)*T(127)));
g1(17,91)=params(21)*y(99)*(-(T(61)*(T(53)*T(64)*T(136)+T(54)*T(66)*T(136))))+params(21)*y(100)*T(137);
g1(17,38)=T(20)*y(60)+params(21)*y(102)*(-(T(20)*(1-params(10))))+params(21)*y(98)*(-(T(60)*T(156)+T(57)*T(57)*T(127)))+params(21)*y(99)*(-(T(61)*(T(63)*T(64)*T(154)+T(53)*T(63)*T(66)+T(53)*T(63)*T(66)+T(54)*T(63)*T(158))))+params(21)*y(100)*(-(T(52)*(T(66)*T(68)*T(69)+T(67)*T(68)*T(158)+T(66)*T(68)*T(69)+T(64)*T(68)*T(161))))+params(21)*y(101)*(-(exp((1-params(3))*y(92))*exp(T(1)*y(96))*params(3)*params(3)*exp(params(3)*y(38))));
g1(17,92)=params(21)*y(98)*(-(T(60)*T(194)+T(57)*T(127)*T(51)*T(56)*T(54)*T(193)))+params(21)*y(99)*(-((T(53)*T(63)*T(64)+T(54)*T(63)*T(66))*T(195)+T(61)*(T(53)*T(63)*T(65)*T(54)*T(193)+T(54)*T(63)*T(196))))+params(21)*y(100)*(-((T(67)*T(66)*T(68)+T(64)*T(68)*T(69))*T(193)+T(52)*(T(67)*T(68)*T(196)+T(69)*T(68)*T(65)*T(54)*T(193))))+params(21)*y(101)*(-(exp(T(1)*y(96))*params(3)*exp(params(3)*y(38))*(1-params(3))*exp((1-params(3))*y(92))));
g1(17,96)=params(21)*y(98)*(-(T(60)*T(213)+T(57)*T(127)*T(58)*(1-params(11))*T(1)*exp(T(1)*y(96))))+params(21)*y(99)*(-(T(61)*T(215)))+params(21)*y(100)*(-(T(52)*T(216)))+params(21)*y(101)*(-(exp((1-params(3))*y(92))*params(3)*exp(params(3)*y(38))*T(1)*exp(T(1)*y(96))));
g1(17,98)=params(21)*(-(T(57)*T(60)));
g1(17,99)=params(21)*(-(T(61)*(T(53)*T(63)*T(64)+T(54)*T(63)*T(66))));
g1(17,100)=params(21)*T(70);
g1(17,101)=params(21)*(-(exp((1-params(3))*y(92))*exp(T(1)*y(96))*params(3)*exp(params(3)*y(38))));
g1(17,60)=T(20);
g1(17,102)=params(21)*(-(T(20)*(1-params(10))));
g1(18,22)=exp(y(22))*exp(y(25))*T(74);
g1(18,23)=(-exp(y(23)))*T(74);
g1(18,25)=T(33)*T(74);
g1(18,36)=y(55)*(-(T(84)*params(11)*T(46)*T(125)));
g1(18,37)=T(131);
g1(18,13)=y(59)*(-(T(75)*exp(T(1)*y(44))*params(3)*exp(y(13)*params(3))))+y(58)*(-(T(77)*(T(19)*T(18)*T(78)*T(139)+T(16)*T(18)*T(141))+T(5)*(T(18)*T(79)*T(141)+T(19)*T(18)*T(145))))+y(57)*(-(T(17)*(T(15)*T(79)*T(138)+T(3)*T(15)*T(145))+T(81)*T(146)))+y(55)*(-(T(84)*T(125)*T(140)+T(47)*T(148)));
g1(18,14)=y(62)*T(166);
g1(18,39)=(T(33)-exp(y(23)))*T(173)+y(62)*(-(params(1)*T(173)/T(26)))+T(4)*y(61)+y(59)*(-(exp(T(1)*y(44))*exp(y(13)*params(3))*(1-params(3))*T(75)))+y(58)*T(178)+y(57)*T(182)+y(55)*(-(T(84)*T(84)*T(125)+T(47)*T(183)))+params(21)*y(103)*T(185);
g1(18,92)=params(21)*y(103)*(-((-(T(74)*T(200)))/(T(24)*T(24))));
g1(18,15)=y(62)*T(201);
g1(18,40)=(T(33)-exp(y(23)))*T(203)+y(62)*(-(params(1)*T(203)/T(26)))+params(21)*y(103)*T(205);
g1(18,93)=params(21)*y(103)*(-((-(T(74)*params(1)*exp(y(93))*T(199)))/(T(24)*T(24))));
g1(18,44)=y(59)*(-(T(75)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))))+T(189)+T(190)+y(55)*(-(T(47)*T(191)+T(84)*T(95)*T(125)));
g1(18,45)=T(192);
g1(18,52)=T(74)*T(104);
g1(18,55)=(-(T(47)*T(84)));
g1(18,57)=T(82);
g1(18,58)=T(80);
g1(18,59)=T(76);
g1(18,61)=T(4);
g1(18,62)=(-(params(1)*T(74)/T(26)));
g1(18,103)=params(21)*(-((-(T(74)*T(86)))/(T(24)*T(24))));
g1(19,22)=T(106);
g1(19,23)=(-exp(y(23)))*T(87);
g1(19,25)=T(33)*T(87);
g1(19,14)=y(62)*T(167);
g1(19,39)=(T(33)-exp(y(23)))*T(186)+y(62)*(-(params(1)*T(186)/T(26)))+params(21)*y(103)*(-(T(187)/T(184)));
g1(19,92)=params(21)*y(103)*(-((-(T(87)*T(200)))/(T(24)*T(24))));
g1(19,15)=y(62)*T(202);
g1(19,40)=(T(33)-exp(y(23)))*T(206)+y(62)*(-(params(1)*T(206)/T(26)))+exp(y(40))*y(60)+params(21)*y(103)*(-((T(24)*T(24)*(-(T(86)*T(206)))-(-(T(86)*T(87)))*T(204))/T(184)));
g1(19,93)=params(21)*y(103)*(-((-(T(87)*params(1)*exp(y(93))*T(199)))/(T(24)*T(24))));
g1(19,45)=T(87)*T(98);
g1(19,52)=T(87)*T(104);
g1(19,60)=exp(y(40));
g1(19,62)=T(88);
g1(19,103)=params(21)*(-((-(T(86)*T(87)))/(T(24)*T(24))));
g1(20,41)=exp(y(41))*y(58)+T(89);
g1(20,43)=T(89);
g1(20,58)=exp(y(41));
g1(20,17)=T(30)*(-(exp(y(41))*exp(y(43))));
g1(21,42)=exp(y(42))*y(57)+y(61)*(-(T(21)*T(209)));
g1(21,57)=exp(y(42));
g1(21,61)=(-(T(21)*T(90)));
g1(22,22)=T(107);
g1(22,11)=T(114);
g1(22,34)=T(117);
g1(22,35)=T(30)*y(19)*(-(exp(y(43))*(1-params(7))));
g1(22,41)=T(89);
g1(22,43)=T(91);
g1(22,17)=T(30)*(-(exp(y(43))*(1+exp(y(41))-params(10))));
g1(22,62)=exp(y(43));
g1(22,18)=T(30)*(-(exp(y(43))*(exp(y(22))*exp(y(11))+y(34)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)))));
g1(22,19)=T(30)*(-(y(35)*exp(y(43))*(1-params(7))));
g1(22,20)=T(30)*(exp(y(43))*params(6)*params(5)*exp(y(11)*(params(5)-1))-exp(y(43))*(exp(y(22))-y(34)));
g1(23,36)=y(55)*(-(T(95)*params(11)*T(46)*T(125)));
g1(23,37)=T(134);
g1(23,13)=y(59)*T(149)+y(58)*(-(T(5)*T(150)))+y(57)*(-(T(17)*T(151)))+y(55)*(-(T(95)*T(125)*T(140)+T(47)*T(94)*T(83)*T(139)));
g1(23,39)=y(59)*(-(T(75)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))))+T(189)+T(190)+y(55)*(-(T(95)*T(84)*T(125)+T(47)*T(191)));
g1(23,44)=y(59)*T(210)+y(58)*(-(T(5)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))))+y(57)*T(211)+y(55)*(-(T(95)*T(95)*T(125)+T(47)*T(212)));
g1(23,55)=(-(T(47)*T(95)));
g1(23,57)=(-(T(17)*T(3)*T(16)*T(93)));
g1(23,58)=(-(T(5)*T(19)*T(16)*T(92)));
g1(23,59)=(-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))));
g1(23,75)=1;
g1(23,110)=params(21)*(-params(15));
g1(23,120)=T(96)*(-params(16));
g1(24,25)=T(99);
g1(24,6)=T(103);
g1(24,10)=T(111);
g1(24,39)=T(192);
g1(24,40)=T(87)*T(98);
g1(24,45)=T(24)*T(218)+T(219);
g1(24,52)=T(24)*T(224);
g1(24,60)=T(102);
g1(24,68)=T(101);
g1(24,72)=T(100);
g1(24,74)=1;
g1(25,77)=1;
g1(26,78)=1;
g1(27,79)=1;
g1(28,80)=1;
g1(29,81)=1;
g1(30,82)=1;
g1(31,25)=T(24)*T(104);
g1(31,39)=T(74)*T(104);
g1(31,40)=T(87)*T(104);
g1(31,45)=T(24)*T(220);
g1(31,52)=exp(y(52))*y(76)+T(24)*T(225);
g1(31,76)=exp(y(52));
g1(32,84)=1;
g1(33,83)=1;
g1(34,36)=(-(params(11)*T(46)*T(47)));
g1(34,37)=exp(y(37));
g1(34,13)=(-(T(47)*T(140)));
g1(34,39)=(-(T(47)*T(84)));
g1(34,44)=(-(T(47)*T(95)));
g1(35,22)=exp(y(22));
g1(35,36)=(-(params(11)*T(12)*T(45)));
g1(35,37)=(-(T(14)*params(11)*T(48)));
g1(36,37)=(-(T(17)*T(3)*T(16)*T(50)));
g1(36,13)=(-(T(17)*T(146)));
g1(36,39)=T(82);
g1(36,42)=exp(y(42));
g1(36,44)=(-(T(17)*T(3)*T(16)*T(93)));
g1(37,37)=(-(T(5)*T(19)*T(16)*T(49)));
g1(37,13)=(-(T(5)*(T(19)*T(18)*T(78)*T(139)+T(16)*T(18)*T(141))));
g1(37,39)=T(80);
g1(37,41)=exp(y(41));
g1(37,44)=(-(T(5)*T(19)*T(16)*T(92)));
g1(38,33)=exp(y(33));
g1(38,13)=(-(exp(y(39)*(1-params(3)))*exp(T(1)*y(44))*params(3)*exp(y(13)*params(3))));
g1(38,39)=T(76);
g1(38,44)=(-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))));
g1(39,23)=exp(y(23));
g1(39,24)=exp(y(24));
g1(39,6)=params(6)*exp(params(5)*(y(10)-y(45)))*exp(y(6));
g1(39,7)=params(6)*exp(params(5)*y(11))*exp(y(7));
g1(39,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(45)));
g1(39,11)=exp(y(7))*params(6)*params(5)*exp(params(5)*y(11));
g1(39,37)=(-exp(y(37)));
g1(39,13)=(-(exp(y(13))*(1-params(10))));
g1(39,38)=T(20);
g1(39,40)=exp(y(40));
g1(39,45)=T(102);
g1(40,39)=T(4);
g1(40,42)=(-(T(21)*T(90)));
g1(41,94)=(-(exp(y(95))*exp(y(94))));
g1(41,95)=(-(exp(y(95))*(1+exp(y(94))-params(10))));
g1(42,14)=(-((-(params(1)*T(24)*T(165)))/(T(26)*T(26))));
g1(42,39)=(-(params(1)*T(74)/T(26)));
g1(42,15)=(-((-(params(1)*T(24)*exp(y(15))*T(164)))/(T(26)*T(26))));
g1(42,40)=T(88);
g1(42,43)=exp(y(43));
g1(43,87)=T(108);
g1(43,32)=T(43);
g1(43,34)=1;
g1(43,88)=(-(exp(y(95))*(1-exp(y(32)))));
g1(43,95)=(-(exp(y(95))*(exp(y(32))*exp(y(87))+(1-exp(y(32)))*y(88)-params(6)*exp(params(5)*y(32)))));
g1(44,34)=(-params(7));
g1(44,35)=1;
g1(44,89)=(-(exp(y(95))*(1-params(7))));
g1(44,95)=(-(exp(y(95))*(1-params(7))*y(89)));
g1(45,24)=y(35)*T(27)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(45,35)=params(4)*exp(y(24)*(params(4)-1))*T(27);
g1(46,87)=(-(exp(y(95))*exp(y(87))));
g1(46,32)=T(42);
g1(46,88)=exp(y(95));
g1(46,95)=T(105);
g1(47,7)=(-(exp(y(7))*(1-exp(y(11)))));
g1(47,28)=exp(y(28));
g1(47,30)=(-(params(7)*exp(y(30))));
g1(47,11)=(-(exp(y(7))*(-exp(y(11)))));
g1(48,6)=(-(exp(y(6))*(1-exp((-y(45)))*exp(y(10)))));
g1(48,27)=exp(y(27));
g1(48,29)=(-(params(7)*exp(y(29))));
g1(48,10)=T(112);
g1(48,45)=T(101);
g1(49,24)=(-(T(27)*params(4)*exp(y(24)*params(4))));
g1(49,9)=(-((1-params(7))*exp(y(9))));
g1(49,30)=exp(y(30));
g1(50,23)=(-(T(28)*params(4)*exp(y(23)*params(4))));
g1(50,8)=(-((1-params(7))*exp(y(8))));
g1(50,29)=exp(y(29));
g1(51,26)=exp(y(26));
g1(51,7)=(-(exp(y(7))*exp(y(11))));
g1(51,11)=(-(exp(y(7))*exp(y(11))));
g1(52,25)=exp(y(25));
g1(52,6)=T(109);
g1(52,10)=T(109);
g1(52,45)=T(100);
g1(53,25)=(-exp(y(25)));
g1(53,26)=(-exp(y(26)));
g1(53,36)=T(8);
g1(54,45)=1;
g1(54,121)=(-1);
g1(55,16)=(-params(15));
g1(55,44)=1;
g1(55,122)=(-1);
g1(55,21)=(-params(16));
g1(56,10)=(-exp(y(10)));
g1(56,52)=exp(y(52));
g1(57,1)=1;
g1(57,22)=(-1);
g1(57,46)=1;
g1(58,3)=1;
g1(58,24)=(-1);
g1(58,47)=1;
g1(59,2)=1;
g1(59,23)=(-1);
g1(59,48)=1;
g1(60,5)=1;
g1(60,26)=(-1);
g1(60,49)=1;
g1(61,4)=1;
g1(61,25)=(-1);
g1(61,50)=1;
g1(62,12)=1;
g1(62,37)=(-1);
g1(62,51)=1;
g1(63,7)=1;
g1(63,28)=(-1);
g1(63,54)=1;
g1(64,6)=1;
g1(64,27)=(-1);
g1(64,53)=1;
g1(65,110)=(-1);
g1(65,85)=1;
g1(66,16)=(-1);
g1(66,86)=1;

end
